function mueller_partial_polarizer,trans,p,angle

;  procedure to calculate the mueller matrix of a partial polarizer given its
;  transmission, trans, partial polarization, p, and orientation angle (angle, degrees)

ang=angle*!dpi/180.d0  ;convert to radians
c2=cos(2.d0*ang) & s2=sin(2.d0*ang)

k1=trans*(1.d0+p)/2.d0
k2=trans*(1.d0-p)/2.d0

matrix=[[(k1+k2),  c2*(k1-k2), s2*(k1-k2),  0.d0],$
 [c2*(k1-k2), c2^2*(k1+k2)+2.0*s2^2*sqrt(k1*k2), s2*c2*(k1+k2)-2.d0*s2*c2*sqrt(k1*k2), 0.d0],$
 [s2*(k1-k2), s2*c2*(k1+k2)-2.d0*s2*c2*sqrt(k1*k2), s2^2*(k1+k2)+2.0*c2^2*sqrt(k1*k2), 0.d0],$
 [0.d0, 0.d0, 0.d0, 2.d0*sqrt(k1*k2)]]

return,matrix
end
