
function comps_fit_for_omx_st_jr  

;  procedure to fit the given observed intensities for the four
;  modulation states for the seven calibration states

common calibrate,i_obs,wave

debug='yes'
ans=' '

;  ST:
;
;  quantities to be fit are (total of 19):

;  1 - transmission of calibration polarizer (1)
;  1 - transmission of calibration retarder  (1)
;  1 - retardation of calibration retarder   (1)
;  4 - input Stokes vector                   (4)
; 12 - O matrix (12) elements with exception of first element of each row

;  observables are (total of 28):

;  4       - measured intensity with no calibration optics - FLAT
;  4,4,4,4 - measured intensity calibration polarizer at 0, 90, 45, and 135 deg
;  4,4     - measured intensity with cal pol at 0 deg followed by cal ret at +45 and -45
;  4x7=28

;  use powell minimization to find unknowns

nparam=19 ; number of parameters to fit
nobs=7	  ; number of observed states

;  create initial guess
guess=dblarr(nparam,/nozero)

guess[0]=0.5          ;  50% cal polarizer transmission
guess[1]=1.0          ; 100% cal retarder transmission
guess[2]=360.*.25*750./wave     ; 90 degrees * 750_nm/wave_nm retardance

; unpolarized input Stokes vector (with intensity as mean of 4 pol measurements of CLEAR)
mean_i=mean(i_obs[*,0])
guess[3:6]=[mean_i,0.,0.,0.]                                   

; Omatrix guessing
; JR:         (I+Q-(I-Q))/2=Q            (I+U-(I-U))/2=U            (I+V-(I-V))/2=V            
guess[ 7: 9]=[(i_obs[0,1]-i_obs[0,2])/2.,(i_obs[0,3]-i_obs[0,4])/2.,(i_obs[0,5]-i_obs[0,6])/2.]
guess[10:12]=[(i_obs[1,1]-i_obs[1,2])/2.,(i_obs[1,3]-i_obs[1,4])/2.,(i_obs[1,5]-i_obs[1,6])/2.]
guess[13:15]=[(i_obs[2,1]-i_obs[2,2])/2.,(i_obs[2,3]-i_obs[2,4])/2.,(i_obs[2,5]-i_obs[2,6])/2.]
guess[16:18]=[(i_obs[3,1]-i_obs[3,2])/2.,(i_obs[3,3]-i_obs[3,4])/2.,(i_obs[3,5]-i_obs[3,6])/2.]

; intensities normalized to mean unpolarized intensity 
guess[ 7:18]=guess[ 7:18]/mean_i

; guess as input to power
a=guess
; the initial set of directions
xi=dblarr(nparam,nparam) & for i=0,nparam-1 do xi(i,i)=1.d0
; powell itself
powell,a,xi,1.d-8,fmin,'min_funct_st_jr',iter=iter,itmax=50000,/double

; printing
print
printf,2
print,'Powell fitting results'
print,'fmin:',fmin,'  iter:',iter
printf,2,'Powell fitting results'
printf,2,'fmin:',fmin,'  iter:',iter

print,'a-guess'
print,guess
print,'a-fit'
print,a
printf,2,'a-guess'
printf,2,guess
printf,2,'a-fit'
printf,2,a

return,a
end
