;+
;  Name: SCD_Compute_Omatrix
;  
;  Description:
;    Procedure to compute the Modulation matrix (O matrix) from the Calibration observations and the 
;    E matrix. See SCD Calibration writeup for details and references.
;   
;  Inputs:
;    Imeas_nm - calibration observations (n x m) comprised of the n modulated intensities obtained 
;            by observing the m calibration optics 
;    
;    Ematrix - the E matrix (m x 4) computed by the SCD_Compute_Ematrix routine. 
;    
;  Outputs:
;    Omatrix - the modulation matrix (n x 4)
;
;  Keywords:
;    none
;    
;  Examples:
;    SCD_Compute_Omatrix,Imeas,Ematrix
;    
;  Author: S. Tomczyk
;
;  Modification History:
;
;-
pro SCD_Compute_Omatrix,Imeas_nm,Ematrix

Omatrix = Imeas_nm##Ematrix

end
