;; ---------------------------------------------------------------------
;; CoMP-S polarimetric calibration testing of the available dW rouines
;; for determination of the matrices for polarimetric correction of
;; the CoMP-S/SCD data before implementation to the LSO pipeline

;; ---------------------------------------------------------------------
;; Run:
;;
;; comps_basics,'20220804'
;; .r test_pol_cal_data_preparation_v1.pro
;; .r test_pol_cal_data_to_matrices_ad_v1.pro

;; ---------------------------------------------------------------------
;; date: 2022/08/04
date='20220804'

;; ---------------------------------------------------------------------
;; input directory
path_date='/home/choc/comp/lso_observer/data_reduction/actual/'+date
path_in_cal_data=path_date+'_cali/calibration_data/'
path_in_cal_mms=path_date+'_cali/SCD_MMs/'

;; ---------------------------------------------------------------------
;; todo: Calibration Procedure
;; 1. create C = [I in,1 I in,2 … I in,m ] matrix (4 x m) from the
;; calibration optics Mueller matrices using I in,j = MM j I C ,
;; assuming I C = [1,0,0,0]
;; SCD_Create_Cmatrix

;; 2. compute the E matrix (m x 4) from the C matrix using
;; E = C T (C C T ) -1
;; SCD_Create_Ematrix

;; 3. create the I meas n,m matrix (n x m) from the calibration
;; observations comprised of the n intensities for the m
;; calibration states (after bias and flat correction)
;; read sav files

;; 4. compute the O matrix (n x 4) from O = I meas n,m E
;; SCD_Compute_Omatrix

;; 5. compute A = O T O, then D = A -1 O T
;; SCD_Compute_Dmatrix

;; ---------------------------------------------------------------------
;; banner
print
print,' TEST_POL_CAL_DATA_TO MATRICES_AD_V1.PRO'
print
print,' CoMP-S polarimetric calibration testing of the available ST+dW routines'
print,' for determination of the matrices for polarimetric correction of'
print,' the CoMP-S/SCD data before implementation to the LSO pipeline'
print
print,' Date: '+date
print

;; ---------------------------------------------------------------------
;; ---------------------------------------------------------------------
;; ---------------------------------------------------------------------
;; 1/ 0D ad data

;; ---------------------------------------------------------------------
;; reading the I meas n,m matrix (n x m) of the calibration
;; observations CALI comprised of the n intensities for the m
;; calibration states (after dark, flat, chip correction):
;; reading their sav files

print,' Reading the prepared calibration observations CALI data...'
print
restore,path_in_cal_data+'lso_comps_20220804_cali0Dad_reg0587_cam1_set1.sav'
; -> cal_meas_0D_ad + n_pol,n_cal,cal_optics

;; ---------------------------------------------------------------------
;; 1. create C = [I in,1 I in,2 … I in,m ] matrix (4 x m) from the
;; calibration optics Mueller matrices using I in,j = MM j I C ,
;; assuming I C = [1,0,0,0]
;; SCD_Create_Cmatrix

;; reading the MMs (at the moment only the SCD MMs expecting the
;; CoMP-S and the SCD polarimeters are identical)
print,' Creating the C matrix from the MMs and expected I_x[1,0,0,0]...'
print

ic=[1,0,0,0]
SCD_Create_Cmatrix,ic,587.65,Cmatrix,in_dir=path_in_cal_mms;,/plot

;; 2. compute the E matrix (m x 4) from the C matrix using
;; E = C T (C C T ) -1
;; SCD_Create_Ematrix
print,' Creating the E matrix from the C matric...'
print

SCD_Compute_Ematrix,Cmatrix,Ematrix,cal_eff=cal_eff

stop

;; 3. create the I meas n,m matrix (n x m) from the calibration
;; observations comprised of the n intensities for the m
;; calibration states (after bias and flat correction)
;; read sav files

;; 4. compute the O matrix (n x 4) from O = I meas n,m E
;; SCD_Compute_Omatrix

;; 5. compute A = O T O, then D = A -1 O T
;; SCD_Compute_Dmatrix

;; saving

;; ---------------------------------------------------------------------
;; ---------------------------------------------------------------------
;; ---------------------------------------------------------------------
;; 2/ 2D ad data

print
print,' END'
print

end
