;+
;  Name: SCD_Compute_Dmatrix
;  
;  Description:
;    Procedure to compute the demodulation matrix (D matrix) from the modulation matrix (O matrix)
;    see del Toro Iniesta & Collados, App. Opt. 39, 2000 for details.
;   
;  Inputs:
;    Omatrix - modulation matrix (n x 4) that defines the encoding of Stokes vector into modulated 
;              intensity states by the polarimeter, where n is the number of modulation states 
;   
;  Outputs:
;    Dmatrix - demodulation matrix (4 x n) used to convert modulated intensities to Stokes vector
;
;  Keywords:
;    pol_eff - polarimetric efficiency (optional, 4 vector), if present this routine will return the efficiency
;    
;  Examples:
;    SCD_Compute_Dmatrix,Omatrix,Dmatrix
;    SCD_Compute_Dmatrix,Omatrix,Dmatrix,pol_eff=pol_eff
;    
;  Author: S. Tomczyk
;
;  Modification History:
;
;-
pro SCD_Compute_Dmatrix,Omatrix,Dmatrix,pol_eff=pol_eff

Amatrix = transpose(Omatrix)##Omatrix

A_invert = invert(Amatrix,status,/double)

Dmatrix = A_invert##transpose(Amatrix)

if keyword_set(pol_eff) then begin
  s = size(A_invert)
  n = s[1]
  pol_eff = dblarr(n)
  for i=0,n-1 do pol_eff[i] = 1./sqrt(n*A_invert[i,i])
endif

end