;+
;  Name: SCD_Compute_Ematrix
;  
;  Description:
;    Procedure to compute the E matrix from the Calibration matrix (C matrix) based on the formalism
;    of deWijn described in "The Concept of Optimal Calibration". See SCD Calibration writeup for 
;    details and references
;   
;  Inputs:
;    Cmatrix - calibration matrix (4 x m) comprised of the m Stokes vectors produced by the calibration 
;              optics where m is the number of calibration states 
;   
;  Outputs:
;    Ematrix - E matrix (m x 4) is the nominal inverse of C as described by deWijn
;
;  Keywords:
;    cal_eff - calibration efficiency (optional, m vector), if present this routine will return 
;              the calibration efficiency
;    
;  Examples:
;    SCD_Compute_Ematrix,Cmatrix,Ematrix
;    SCD_Compute_Ematrix,Cmatrix,Ematrix,cal_eff=cal_eff
;    
;  Author: S. Tomczyk
;
;  Modification History:
;
;-
pro SCD_Compute_Ematrix,Cmatrix,Ematrix,cal_eff=cal_eff

mx = Cmatrix##transpose(Cmatrix)

mx_invert = invert(mx,status,/double)

Ematrix = transpose(Cmatrix)##mx_invert

if keyword_set(cal_eff) then begin
  s = size(mx)
  n = s[1]
  cal_eff = dblarr(n)
  for i=0,s[1]-1 do cal_eff[i] = 1./sqrt(n*mx[i,i])
endif

end