; program na vypocet azimutu Slnka pocas jednotlivych dni roka
; pre vypocet parametrov pre rotaciu kupoly

; .r rotacia_kupoly_pre_mikroprocesor_v2.pro

; JR, v.2, 2015/02/08



; LSO - Zemepisná poloha: dĺžka - 20° 12' 47.43020", šírka: 49° 11' 42.53495"
lso_long=20.+12./60.+47.43020/3600.
lso_lati=49.+11./60.+42.53495/3600.

; year
yyyy_int=2015
yyyy_str=strcompress(string(yyyy_int),/remove_all)

; calculation of the JD for the beginning of the selected year
;	JDCNV, YR, MN, DAY, HR, JULIAN
; INPUT:
; 	YR = Year, integer scalar or vector
;	MN = Month  integer (1-12) scalar or vector
;	DAY = Day   integer 1-31) scalar or vector 
;	HR  = Hours and fractions of hours of universal time (U.T.), scalar or vector
; OUTPUT:
;	JULIAN = Julian date (double precision) 
;
JDCNV, yyyy_int, 1, 1, 0, jd0

; variables
ndays=366
yr=fltarr(ndays) & mn=yr & day=yr & jd=yr
azi=fltarr(ndays,24*600) & hei=azi

goto,stat_tmp

; cycle of AZI and HEI calculation for each 1 min in each day
tim=fltarr(24*600) ; time diring the dat in 1/10 of a mniute

for j=0,ndays-1 do begin ; j - # number of a day in a year DOY

    print,j
    jd1=jd0+j ; actual JD of this day
    DAYCNV, jd1, yrt, mnt, dayt
    yr(j)=yrt & mn(j)=mnt & day(j)=dayt
    
    for hh=0,24-1 do begin       ; hours
       for mm=00,599,1 do begin  ; 1/10 of a mnute
          
            hhmm=hh+mm/60./10.    ; actual time [HH.HHHH...]
            ; coalculation of the solar position parameters
            zensun,j,hhmm,lso_lati,lso_long,zenith_angle,azimuth_angle,$
                   solfactor, sunrise=sr,sunset=ss
            ;print,jd1,yrt,mnt,dayt,hhmm,zenith_angle,azimuth_angle

            ; filling the time variable with actual time [HH.HHHH...]
            if j eq 0 then tim(hh*600+mm)=hhmm
            ;print,j,hh,mm,hhmm,hh*6.+mm/10.,tim(hh*6.+mm/10.)

            azi(j,hh*600+mm)=azimuth_angle
            hei(j,hh*600+mm)=90.-zenith_angle        
            if azimuth_angle lt 0 then azi(j,hh*600+mm)=360.+azimuth_angle
            if solfactor lt 0 then azi(j,hh*600+mm)=0.
            if solfactor lt 0 then hei(j,hh*600+mm)=0. ;360.+azimuth_angle
            
       endfor  ;mm       
    endfor ;hh    
endfor ; j -day

; summer solstice day = 171
; IDL> p,azi(171,16)-180.     -127.476
; IDL> p,azi(171,112)-180.     127.262
; division of the silstice azimut arc to 255 subarcs of 1 degree width
; arc: no=0 -127 degrees (to E), no=127 0 degrees (S), no 255=128 degrees (to W)

; azi = - when Sun is below the horizon
ind0=where(hei eq 0.)
azi(ind0)=replicate(0.,n_elements(ind0))

; saving needed variables for later faster calculation of the rest
save,filename='azi_hei.xdr',azi,hei,tim

; inversion of the relation: arc_pos ~ time to the relation: time ~ arc_pos
; for non-zero points (Sun above horizon)

; calculation of the time interval needed for the Sun to move in
; azimuth for 1 degreee, i.e. for 5.74213
; as 5.74213 cm na kolajnici kupoly zodpoveda 1 uhlovemu stupnu
; (PH,JR,27/1/2015)

stat_tmp:
restore,'azi_hei.xdr'

time_256=fltarr(ndays,256) ; time variable for day/angle times

for d=0,ndays-1 do begin ; j - # number of a day in a year DOY

    print,d
   
    a=reform(azi(d,*))
    indxn0=where(a ne 0.)
    tn0=tim(indxn0) ; non zero data - time
    an0=a(indxn0)   ; non zero data - angle    
    angle0=180-128.             ; 52 degrees - shift of the zero point from N
                                ; to solar summer solstice azimuth

    for angle=0,256-1 do begin ; cycle of time calcualtion for all non-zero angles

       atmp=angle0+angle
       indl=where(an0 lt atmp)
       indh=where(an0 gt atmp)
       if total(indl) ne -1. and total(indh) ne -1. then begin
          ttmp=(tn0(max(indl))+tn0(min(indh)))/2.
          ;print,angle,atmp,max(indl),tn0(max(indl)),min(indh),tn0(min(indh)),ttmp       
       endif else begin
          ttmp=0.
       endelse
       time_256(d,angle)=ttmp
       
    endfor ; angle - angle
   
 endfor ; d - day

; calculation of the time interval between the solat azimuth positions
; with a distance of 1 degree of arc

time_step=time_256-shift(time_256,0,1) ; time interval
time_step(164:180,0)=time_step(164:180,2) ; corection due to shift truncation
time_step(164:180,1)=time_step(164:180,2)

; edges corrections and smoothing along days

time_step_smooth=fltarr(366,256)

for d=0,ndays-1 do begin        ; j - # number of a day in a year DOY

    print,d

    tmp=reform(time_step(d,*))
    indn0=where(tmp ne 0.)
    tmp1=tmp
    tmp1(indn0(0))=tmp1(indn0(0)+1)
    indne=where(tmp lt 0.)
    tmp1(indne(0))=tmp1(indne(0)-1)
    ; smooth
    indn0=where(tmp1 ne 0.)
    tmp2=tmp1(indn0)
    tmp3=smooth(tmp2,9,/edge_truncate)
    tmp4=tmp
    tmp4(indn0)=tmp3
    time_step_smooth(d,*)=tmp4
    
endfor

; time_step_smooth = time interval for Sun motion in azimuth for 1 degree only [s]
time_step_smooth=time_step_smooth*3600.


; physical [seconds[ to engineering units [0-255] * scale_factor
; min
time_step_smooth_min=min(time_step_smooth(100:200,100:150)) ; 113.333
; MAX
time_step_smooth_max=max(time_step_smooth) ; 342.667
scale_factor=2

time_interval_per_1deg_eng=round(time_step_smooth/float(scale_factor))

; output for an microprocessor reading - ASCII
for d=0,ndays-1 do begin
    for a=0,256-1 do begin
        tmp=time_interval_per_1deg_eng(d,a)  
        tmp1=strcompress(string(tmp),/remove_all)
        if tmp lt 10 then tmp1='00'+tmp1
        if tmp lt 100 and tmp ge 10 then tmp1='0'+tmp1        
        if d eq 0 and a eq 0 then begin
           out=tmp1
        endif else begin
           out=out+tmp1
        endelse
        ;print,d,a,' ',tmp1,' ',out
        ;stop
    endfor
    ;if d eq 171 then stop
endfor
openw,1,yyyy_str+'_dome_rotation_eng_data_ascii.dat'
printf,1,out
close,/all

; output for an microprocessor reading - BYTE
time_interval_per_1deg_eng_byte=byte(time_interval_per_1deg_eng)
openw,1,yyyy_str+'_dome_rotation_eng_data_byte.dat'
writeu,1,transpose(time_interval_per_1deg_eng_byte)
close,/all

;stop

; ASCII FILE:
;
; format - 1 line of: ndays * (256 azimuth positions = 366 * 256
;          = 93696 data when each if of the a3 format, i.e. the file
;          format is 93696a3=a281088 = 281088 bytes + ENDFILE mark
;          example: 000000000000234212....
;          000 means no motion (Sun is below the horizon)
;          234 means 234 * scale_factor [s] after which the dome
;          should move toward W for 1 angular degree, i.e. 5.74213 cm
;
;          scale_factor      2 second/arbitrary 8bit unit
;          file='2015_dome_rotation_eng_data_ascii.dat'

; BYTE FILE:
;
; format - 1 line of: ndays * (256 azimuth positions = 366 * 256
;          = 93696 byte data, i.e. the file format is 93696 bytes
;            0 means no motion (Sun is below the horizon)
;          234 means 234 * scale_factor [s] after which the dome
;          should move toward W for 1 angular degree, i.e. 5.74213 cm
;
;          scale_factor      2 second/arbitrary 8bit unit
;          file='2015_dome_rotation_eng_data_byte.dat'

print,' End'
print

end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; NAME:
;	JDCNV; PURPOSE:
;	Converts Gregorian dates to Julian days   
;
; EXPLANATION:
;       For IDL versions V5.1 or greater, this procedure is superceded by
;       JULDAY() function in the standard IDL distribution.   Note, however,
;       that prior to V5.1 there wasa bug in JULDAY() that gave answers off
;       by 0.5 days. 
;        
; CALLING SEQUENCE:
;	JDCNV, YR, MN, DAY, HR, JULIAN
;
; INPUTS:
; 	YR = Year, integer scalar or vector
;	MN = Month  integer (1-12) scalar or vector
;	DAY = Day   integer 1-31) scalar or vector 
;	HR  = Hours and fractions of hours of universal time (U.T.), scalar
;              or vector
;		
; OUTPUTS:
;	JULIAN = Julian date (double precision) 
;
; EXAMPLE:
;	To find the Julian Date at 1978 January 1, 0h (U.T.)
;
;	IDL> JDCNV, 1978, 1, 1, 0., JULIAN
;
;	will give JULIAN = 2443509.5
; NOTES:
;	(1) JDCNV will accept vector arguments 
;	(2) JULDATE is an alternate procedure to perform the same function
;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; NAME:
;       SUNPOS
; PURPOSE:
;       To compute the RA and Dec of the Sun at a given date.
;
; CALLING SEQUENCE:
;       SUNPOS, jd, ra, dec, [elong, obliquity, /RADIAN ]
; INPUTS:
;       jd    - The Julian date of the day (and time), scalar or vector
;               usually double precision
; OUTPUTS:
;       ra    - The right ascension of the sun at that date in DEGREES
;               double precision, same number of elements as jd
;       dec   - The declination of the sun at that date in DEGREES
;
; OPTIONAL OUTPUTS:
;       elong - Ecliptic longitude of the sun at that date in DEGREES.
;       obliquity - the obliquity of the ecliptic, in DEGREES
;
; OPTIONAL INPUT KEYWORD:
;       /RADIAN - If this keyword is set and non-zero, then all output variables 
;               are given in Radians rather than Degrees
;
; NOTES:
;       Patrick Wallace (Rutherford Appleton Laboratory, UK) has tested the
;       accuracy of a C adaptation of the sunpos.pro code and found the 
;       following results.   From 1900-2100 SUNPOS  gave 7.3 arcsec maximum 
;       error, 2.6 arcsec RMS.  Over the shorter interval 1950-2050 the figures
;       were 6.4 arcsec max, 2.2 arcsec RMS.  
;
;       The returned RA and Dec are in the given date's equinox.
;
;       Procedure was extensively revised in May 1996, and the new calling
;       sequence is incompatible with the old one.
; METHOD:
;       Uses a truncated version of Newcomb's Sun.    Adapted from the IDL
;       routine SUN_POS by CD Pike, which was adapted from a FORTRAN routine
;       by B. Emerson (RGO).
; EXAMPLE:
;       (1) Find the apparent RA and Dec of the Sun on May 1, 1982
;       
;       IDL> jdcnv, 1982, 5, 1,0 ,jd      ;Find Julian date jd = 2445090.5   
;       IDL> sunpos, jd, ra, dec
;       IDL> print,adstring(ra,dec,2)
;                02 31 32.61  +14 54 34.9
;
;       The Astronomical Almanac gives 02 31 32.58 +14 54 34.9 so the error
;               in SUNPOS for this case is < 0.5".      
;
;       (2) Find the apparent RA and Dec of the Sun for every day in 1997
;
;       IDL> jdcnv, 1997,1,1,0, jd                ;Julian date on Jan 1, 1997
;       IDL> sunpos, jd+ dindgen(365), ra, dec    ;RA and Dec for each day 

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; ROUTINE:      zensun
;
; PURPOSE:      Compute solar position information as a function of
;               geographic coordinates, date and time.
;
; USEAGE:       zensun,day,time,lat,lon,zenith,azimuth,solfac,sunrise,sunset,
;                  local=local
;
; INPUT:
;   day         Julian day (positive scalar or vector)
;               (spring equinox =  80)
;               (summer solstice= 171)
;               (fall equinox   = 266)
;               (winter solstice= 356)
;
;   time        Universal Time in hours (scalar or vector)
;
;   lat         geographic latitude of point on earth's surface (degrees)
;
;   lon         geographic longitude of point on earth's surface (degrees)
;
; OUTPUT:
;
;   zenith      solar zenith angle (degrees)
;
;   azimuth     solar azimuth  (degrees)
;               Azimuth is measured clockwise from due north
;
;   solfac      Solar flux multiplier.  SOLFAC=cosine(ZENITH)/RSUN^2
;               where rsun is the current earth-sun distance in
;               astronomical units.
;
;               NOTE: SOLFAC is negative when the sun is below the horizon
