
PRO window_plot_save_end_jr, key_plot, pathfilename_out=pathfilename_out ;

; .comp window_plot_save_end_jr.pro

; INPUT: key_plot = 0 - only X window
;                   1 - X window        + PNG graphical format file
;                   2 - RAM@console     + PNG graphical format file (window command /PIXMAP keyword
;                   3 - Z-buffer@server + PNG graphical format file
;                   4 - EPS graphical format file only
;
;        pathfilename_out - path + filename of the output grahical
;                           format file (without extension) - needed here only for PNG 
    
; input variable check
if key_plot lt 0 or key_plot gt 4 then begin
   print
   print,' WINDOW_PLOT_SAVE_END_JR procedure: wrong value of the KEY_PLOT input variable'
   print
   return
endif

pathfilename_out_save=pathfilename_out

if key_plot ge 1 and key_plot le 3 and keyword_set(pathfilename_out) eq 0 then pathfilename_out='idl_window_plot_output_'+SYSTIME(/UTC)

; X only
if key_plot eq 0 then return

; X + PNG or X + PNG through RAM@console
if key_plot eq 1 or key_plot eq 2 then begin
   window_2_png, pathfilename_out
endif

; Z-buffer@server + PNG graphical format file
if key_plot eq 3 then begin
   window_2_png, pathfilename_out
   device_z_2_x
endif

; EPS graphical format file only
if key_plot eq 4 then begin
   device_eps_2_x
endif

pathfilename_out=pathfilename_out_save

return
end
