
FUNCTION time_hh_2_time_dec_jd, time_hh, yy,mm,dd

yy=float(yy) & mm=float(mm) & dd=float(dd)

format_limit_hhmmss_hhmm=2. ; [min]

if max(time_hh)-min(time_hh) gt format_limit_hhmmss_hhmm/60. then begin ; format HH:MM
   ; TIME: HH:MM from t_start [UT]
   ; time label format
   date_label = LABEL_DATE(DATE_FORMAT = ['%H:%I'])
   ; time_dec - HH.HHHH
   ; HH.HHHH -> FOD
   time_fod=time_hh/24.
   ; FOD -> JUL DATE
   time_dec_jd=dblarr(n_elements(time_fod))
   for i=0L,n_elements(time_fod)-1 do begin
      JULDATE, [yy,mm,dd+time_fod(i)],tmpq 
      time_dec_jd(i)=tmpq
   endfor
endif else begin ; format HH:MM:SS
      ; TIME: HH:MM from t_start [UT]
   ; time label format
   date_label = LABEL_DATE(DATE_FORMAT = ['%H:%I:%S'])
   ; time_dec - HH.HHHH
   ; HH.HHHH -> FOD
   time_fod=time_hh/24.
   ; FOD -> JUL DATE
   time_dec_jd=dblarr(n_elements(time_fod))
   for i=0L,n_elements(time_fod)-1 do begin
      JULDATE, [yy,mm,dd+time_fod(i)],tmpq 
      time_dec_jd(i)=tmpq
   endfor
endelse

return,time_dec_jd
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO hm_line_time_2d_plot_equidistant, window_sel, title_sel, time,frequency, arr, date,$
                          time_fod,$
                          yrange,lut,ps_plot=ps_plot,charthick=charthick,$
                          invert=invert,range_adjust=range_adjust,xminor=xminor,charsize=charsize,$
                          position=position,nodata=nodata,xticklen=xticklen,yticklen=yticklen,$
                          colorbar_radio_format=colorbar_radio_format,xticks=xticks,font=font
  
;fnt='!6'
fnt=''
font=1

;erase
;col=!P.Background

if n_elements(xticks) eq 0 then xticks=3
  
format_limit_hhmmss_hhmm=3.   ; [min]
time_hh_tmp=time/3600.
if max(time_hh_tmp)-min(time_hh_tmp) gt format_limit_hhmmss_hhmm/60. then begin ; format HH:MM
   date_label = LABEL_DATE(DATE_FORMAT = [fnt+'%H:%I'])
   xtitle=fnt+'UT [HH:MM]'
endif else begin
   date_label = LABEL_DATE(DATE_FORMAT = [fnt+'%H:%I:%S'])
   xtitle=fnt+'UT [HH:MM:SS]'
endelse

if n_elements(invert) eq 0 then begin
   invert=0
endif else begin
   invert=1
endelse
if n_elements(range_adjust) eq 0 then range_adjust=0
if n_elements(ps_plot) eq 0 then ps_plot=0
if n_elements(position) eq 0 then POSITION=[0.1,.1,.95,.95]
thisposition=position
if n_elements(nodata) eq 0 then nodata=0
if n_elements(charsize) eq 0 then charsize=1.0
if n_elements(colorbar_radio_format) eq 0 then colorbar_radio_format='(i5)'

;print
;print,' DISPLAY OF 2D LINE_TIME AIA ARRAY: '+title_sel

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
arrtmp=arr

; congriding in case of low number of pixels
size_arr=size(arr)
nx_min=512 & ny_min=256
if size_arr(1) lt nx_min or size_arr(2) lt ny_min then begin
   arr_cong=congrid(arr,nx_min,ny_min,/center,/cubic)
arr_save=arr
arrtmp=arr_cong
time_fod_save=time_fod
time_fod=congrid(time_fod,nx_min)
frequency_save=frequency
frequency=congrid(frequency,ny_min)
endif

;window,window_sel,title=title_sel
loadct,lut,/silent,file='colors1.tbl'
displayColors=!D.N_COLORS
min_display=min(arrtmp) & max_display=max(arrtmp)
;print,min_display,max_display
;max_display=250.

stat_new_rage:
im=bytscl(arrtmp,min=min_display,max=max_display,top=displayColors-1)
if invert eq 1 then im=255-im
;THISPOSITION=[0.1,.1,.95,.95]
if nodata eq 0 then begin
   TVLCT, r, g, b, /Get
   TVLCT, Reverse(r), Reverse(g), Reverse(b)
   ;plot,findgen(2) &
   erase
endif

if nodata eq 0 then TVSCALE, 255-im, Bottom=0, top=255,position=thisPosition

time_hh=time_fod*24.

yy=strmid(date,0,4) & mm=strmid(date,4,2) & dd=strmid(date,6,2)
time_dec_jd=time_hh_2_time_dec_jd(time_hh, yy,mm,dd)

; colors variables
levels = 128.
tmp=float(im)
step = (Max(tmp) - Min(tmp)) / levels
;p,step
userLevels = IndGen(levels) * step
if nodata eq 0 then begin
   if max(time_hh_tmp)-min(time_hh_tmp) gt format_limit_hhmmss_hhmm/60. then begin ; format HH:MM
      date_label = LABEL_DATE(DATE_FORMAT = ['%H:%I:%S'])
      xtitle=fnt+'UT [HH:MM:SS]'
      
      CONTOUR, im,time_dec_jd,frequency, $
         POSITION=thisPosition, /NOERASE, XSTYLE=1, YSTYLE=1,$
               Min_value=0, max_value=255, $
               ytitle=fnt+'FREQUENCY [MHz]', /fill,$
         xtitle=xtitle,yrange=yrange,/nodata,charsize=charsize,charthick=charthick,xticks=xticks,$
         xticklen=xticklen, yticklen=yticklen,$
         XTICKFORMAT =fnt+'LABEL_DATE', XTICKUNITS = 'Time',xminor=xminor,$
         levels=userLevels, Color=255, font=font 
      TVLCT, r, g, b, /Get
      TVLCT, Reverse(r), Reverse(g), Reverse(b)

   endif else begin
      date_label = LABEL_DATE(DATE_FORMAT = fnt+['%H:%I:%S'])
      xtitle=fnt+'UT [HH:MM:SS]'
      CONTOUR, im,time_dec_jd,frequency, $
         POSITION=thisPosition, /NOERASE, XSTYLE=1, YSTYLE=1,$
               Min_value=0, max_value=255,$
         ytitle=fnt+'FREQUENCY [MHz]', /fill,charthick=charthick,$
         xtitle=xtitle,yrange=yrange, /nodata,charsize=charsize,xticks=xticks,$
         xticklen=xticklen, yticklen=yticklen,$
         XTICKFORMAT =fnt+'LABEL_DATE', XTICKUNITS = 'Time',xminor=xminor,$
         levels=userLevels, Color=255 , font=font 
   endelse

endif else begin
     CONTOUR, im,time_dec_jd,frequency, $
         POSITION=thisPosition, /NOERASE, XSTYLE=1, YSTYLE=1,$
         Min_value=0, max_value=255, ytitle=fnt+'FREQUENCY [MHz]',$
         ;title=title,
         /fill,/follow,$
         xtitle=xtitle,yrange=yrange,/nodata,charsize=charsize,$
         xticklen=yticklen, yticklen=yticklen,charthick=charthick,$
              ;XTICKFORMAT = 'LABEL_DATE', XTICKUNITS = 'Time',xminor=xminor,$
              XTICKFORMAT = date_label, XTICKUNITS = 'Time',xminor=xminor,$              
         levels=userLevels, Color=0, font=font     
endelse

;print,'hm:font',font

if range_adjust eq 1 then begin

; histoplot for a convenient selection of the data display range
tmp=moment(arrtmp) & arrmea=tmp(0)
arrmed=median(arrtmp) ; median value
range=max_display-min_display; range 
nbin=100 ; number of bins
binsize=range/float(nbin) ; needed for proper calculations of histogram
;if binsize le 1.0 then begin ; lower limit of binsize for histogram
;   binsize=1.0
;   nbin=range
;endif
x=min_display+findgen(nbin)*binsize ; plot x axis + y axis
y=float(Histogram(arrtmp, min=min_display, max=max_display,binsize=binsize)) 
y=y/max(y) ; normalisation
window_hist=30 ; temporal window for histogram plots
!p.multi=[0,1,2] ; two panels
window,window_hist,title='DATA HISTOGRAM: LINEAR + LOGARITHMIC'
Plot, x,y,yrange=[-0.05,1.05],xtitle='DATA VALUE',YTITLE='NUMBER OF DATA',$
         title='DYNAMIC RANGE:   FULL = '+$
         strcompress(string((min(arrtmp))),/remove_all)+$
         ' - '+strcompress(string((max(arrtmp))),/remove_all)+$
         '  APPLIED = '+$
         strcompress(string((min_display)),/remove_all)+$
         ' - '+strcompress(string((max_display)),/remove_all), font=font 
oplot,[arrmed,arrmed],[-0.05,1.05],linesty=0 ; median
oplot,[arrmea,arrmea],[-0.05,1.05],linesty=2 ; mean
oplot,[min(x),max(x)],[0,0],linesty=1 ; zero horizontal line
Plot, x,y>0.00001,yrange=[0.00001,1.05],xtitle='DATA VALUE'$
      ,YTITLE='LOG10(NUMBER OF DATA)',/ylog
oplot,[arrmed,arrmed],[0.00001,1.05],linesty=0
oplot,[arrmea,arrmea],[0.00001,1.05],linesty=2
!p.multi=0
wset,window_sel ; return to the 2D map plot
;
stat_tmp1tmp2:
print,' INFO : full dynamic flux range    = ',min(arrtmp),' -',max(arrtmp)
print,' INFO : applied dynamic flux range = ',min_display,' -',max_display
read,min_display,max_display,$
     prompt=' INPUT: min, MAX values of the data 2D array (0,0=OK) = ' 
if min_display eq 0 and max_display eq 0 then goto, stat_range_ok
if min_display ge max_display then begin
   print,' WARNING: lower limit > or = to upper limit ! Insert new values...'
   goto,stat_tmp1tmp2
endif
if min_display ne 0 or max_display ne 0 then goto, stat_new_rage
stat_range_ok:
wdelete,window_hist

endif ; range adjusr end

if ps_plot ne 0 then begin
read,key_ps_plot,$
     prompt=' INPUT: A4 landscape PS plot (0-none,1) = ' 
if key_ps_plot eq 1 then begin

print,' '
print,' A4 PS output of the plot/image :'
;print,' '
fileout=' '
read, fileout, prompt=' INPUT : output file name (without extension) : '
fileout=fileout+'.ps'

set_plot,'ps'
;device, /encapsulated
device,/times
device, /color, /landscape
device, bits=8, filename=fileout

;print,' '
print,' INFO : the A4 PS output prepared, repeating the plotting commands !'
;print,' '

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
TVSCALE, im, Bottom=0, top=255,position=thisPosition
CONTOUR, im,time,frequency, $
	POSITION=thisPosition, /NOERASE, XSTYLE=1, YSTYLE=1,$
	Min_value=0, max_value=255, $
	ytitle='LENGTH [arcsecs]',$;,LEVELS=levels,C_COLORS=colors, $
	xtitle='TIME [hours]',/fill,yrange=yrange, $
	title=title_sel,$;+
        /nodata,$
        xticklen=0.02, yticklen=0.02
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; closing of the opened PS device
device, /close

; back to X
set_plot,'x'

;print,' '
print,' INFO : Output returned back to X !'
print,' '
endif
endif

stat_end:

; congriding in case of low number of pixels - return of in/out viariables
if size_arr(1) lt nx_min or size_arr(2) lt ny_min then begin
   arr=arr_save
   time_fod=time_fod_save
   frequency=frequency_save
endif

return
end
