

pro mrd_skip, unit, nskip
        On_error,2

    if nskip le 0 then return
        compress = (fstat(unit)).compress

; We try to use POINT_LUN but if an error ocurrs, we just read in the bytes 

          if ~compress then begin
      On_IOerror, byte_read
      point_lun, -unit, curr_pos
      On_IOerror, null
          if curr_pos NE -1 then point_lun, unit, long64(curr_pos) + nskip
           return
      endif 

; Otherwise, we have to explictly read the number of bytes to skip
; If the number is very large we don't want to create a array so skip
; in chunks of 8 Megabyte

byte_read:

        chunk = 8000000L
    buf = bytarr(nskip<chunk, /nozero)
    nleft = nskip
    on_ioerror, DONE
    while (nleft gt 0) do begin
        readu, unit, buf
        nleft = nleft - chunk
            if (nleft gt 0) && (nleft lt chunk) then buf = buf[0:nleft-1]   
    endwhile
    return
DONE:  message,'Warning - Byte padding in FITS file may not be correct',/CON
       return       
end

