
PRO INTEP_GH_JR, xp,p,x,f,n,ier

;+
; NAME: INTEP_GH_JR
;
; PURPOSE: IDL version of the FORTRAN subroutien of G. HILL for
;          an effective interpolation algorithm  INTEP
;          Graham Hill, 'INTEP, An Effective Interpolation Subroutine',
;          Publications of the Dominion Astrophysical Observatory,
;          Victoria, B.C., Canada, volume XVI, No.6, 1982
;
;          - to interpolate a function value P for a given argument
;            value XP using a table of N values (X,F).
;            This is a Spline Interpolation Scheme based on Hermite
;            polynomials. The source is U.S. Airforce surveys in
;            Geophysics No.272
  
;
; CATEGORY: interpolation
;
; CALLING SEQUENCE: INTEP_GH_JR, xp,p,x,f,n,ier
;
; USAGE : for random values of XP :
;             
;             intep_gh_jr, xp,p,x,f,n,ier
;
; INPUTS: XP - the chosen argument value
;         P  - the resultant interpolated value
;         X  - the vector of independent values
;         F  - the vector of function or dependent values
;         N  - the number of points in the (X,P) vectors
;         IER- the resultant error parameter
;;
; OUTPUTS:
;
;
; RESTRICTIONS: if XP is beyond either extreme in the vector X the
;               value of F at that extreme is adopted and IER set to 2
;
; EXAMPLE:  x=findgen(100)
;           n=n_elements(x)
;           f=x^2.
;           xx=findgen(1000)/10.
;           yy=xx
;           for i=0,1000-1 do begin
;               xp=xx(i)
;               INTEP_GH_JR, xp,p,x,f,n,ier
;               yy(i)=p
;           endfor
;
;           plot,x,f,psym=4
;           oplot,xx,yy
;           end
;
; MODIFICATION HISTORY: 1982 - G. Hill - Fortran subroutine
;                   6/6/2003 :J. Rybak (choc@astro.sk) - IDL procedure
;-
  
ier=1
i0=0
iup=0
if x(1) lt x(0) then iup=1
n1=n-1
n2=n1-1
if (xp ge x(n1) and iup eq 0) or (xp le x(n1) and iup eq 1) then begin
stat_5: p=f(n1)
        goto,stat_6
endif 
if (xp le x(0) and iup eq 0) or (xp ge x(0) and iup eq 1) then begin
        p=f(0)
        goto,stat_6
endif
goto,stat_8
stat_6: ier=2     
goto,stat_end
stat_8: 
for i=i0,n1 do begin
    if xp lt x(i) and iup eq 0 then goto,stat_2
    if xp gt x(i) and iup eq 1 then goto,stat_2
endfor
goto,stat_5
stat_2:
i=i-1
if i eq i0-1 then goto,stat_4
i0=i+1
lp1=1./(x(i)-x(i+1))
lp2=1./(x(i+1)-x(i))
if i eq 0 then fp1=(f(1)-f(0))/(x(1)-x(0))
if i eq 0 then goto,stat_3
fp1=(f(i+1)-f(i-1))/(x(i+1)-x(i-1))
stat_3:
if i ge n2 then fp2=(f(n1)-f(n1-1))/(x(n1)-x(n1-1))
if i ge n2 then goto,stat_4
fp2=(f(I+2)-f(i))/(x(i+2)-x(i))
stat_4:
xpi1=xp-x(i+1)
xpi=xp-x(i)
l1=xpi1*lp1
l2=xpi*lp2
p=f(i)*(1.-2.*lp1*xpi)*l1*l1 + f(i+1)*(1.-2.*lp2*xpi1)*l2*l2 + $
  fp2*xpi1*l2*l2 + fp1*xpi*l1*l1
stat_end: return
end
